# (c) cavaliba.com  - data/api - schema.py


from django.views.decorators.csrf import csrf_exempt, csrf_protect

from django.utils.translation import gettext as _

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL
from app_home.configuration import get_configuration
from app_home.cavaliba import CAVALIBA_VERSION

from app_user.aaa_api import start_api


from app_data.models import DataClass, DataInstance, DataSchema, DataEAV, DataFile

from app_data.data import get_instances
from app_data.data import Instance
from app_data.schema import Schema

from app_data.loader import load_broker
from app_data.pipeline import apply_pipeline
from app_data.pipeline import get_pipeline


import app_data.api.helper as helper


#  ----------------------------------------------------------------------------
# /api/schemas/
#  ----------------------------------------------------------------------------
@csrf_exempt
def schema(request, skey=None):

    aaa_api = start_api(request, permission="p_schema_read")
    if not aaa_api["is_allowed"]:
        return helper.send_denied()

    reply = {}

    # single by keyname (classname)
    if skey:
        sc = Schema.from_name(skey)
        if sc:
            reply = sc.to_dict()
            log(DEBUG, aaa=aaa_api, app="api", view="schemas", action="GET", status="OK", data=f"{sc.classname}")
            return helper.send_response(request, [reply], 200)
        else:
            log(DEBUG, aaa=aaa_api, app="api", view="schemas", action="GET", status="KO", data=f"not found")
            return helper.send_not_found()


    
    # list all
    allobj = Schema.listall_obj()
    for sobj in allobj:
        count = DataInstance.objects.filter(classname=sobj.keyname).count()
        item = {}
        item = {
            "id": sobj.id,
            "keyname": sobj.keyname,
            "displayname": sobj.displayname,
            "is_enabled": sobj.is_enabled,
            "count": count,
        }
        reply[sobj.keyname] = item

    log(DEBUG, aaa=aaa_api, app="api", view="schemas", action="GET", status="OK", data="")
    return helper.send_response(request, reply, 200)


