# Generated by Django 5.0.4 on 2025-02-12 16:50

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='DataClass',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyname', models.SlugField(max_length=128, unique=True)),
                ('displayname', models.CharField(blank=True, max_length=500, null=True)),
                ('is_enabled', models.BooleanField(default=True)),
                ('is_bigset', models.BooleanField(default=False)),
                ('count_estimation', models.IntegerField(default=0)),
                ('handle_method', models.CharField(choices=[('keyname', 'keyname'), ('external', 'external'), ('uuid', 'uuid'), ('md5', 'md5')], default='keyname', max_length=32)),
                ('icon', models.CharField(blank=True, default='', max_length=128, verbose_name='Icon')),
                ('page', models.CharField(blank=True, max_length=255, null=True)),
                ('order', models.IntegerField(default=100)),
                ('p_create', models.CharField(blank=True, max_length=256, null=True)),
                ('p_read', models.CharField(blank=True, max_length=256, null=True)),
                ('p_update', models.CharField(blank=True, max_length=256, null=True)),
                ('p_delete', models.CharField(blank=True, max_length=256, null=True)),
                ('p_export', models.CharField(blank=True, max_length=256, null=True)),
                ('p_import', models.CharField(blank=True, max_length=256, null=True)),
                ('p_admin', models.CharField(blank=True, max_length=256, null=True)),
            ],
            options={
                'verbose_name': 'Cavaliba Data Class',
                'verbose_name_plural': 'Cavaliba Data Classes',
                'ordering': ['keyname'],
            },
        ),
        migrations.CreateModel(
            name='DataInstance',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyname', models.CharField(max_length=256)),
                ('handle', models.SlugField(blank=True, max_length=128, null=True)),
                ('displayname', models.CharField(blank=True, max_length=500, null=True)),
                ('is_enabled', models.BooleanField(default=True)),
                ('data_json', models.TextField(blank=True, max_length=5000, null=True)),
                ('p_read', models.CharField(blank=True, max_length=256, null=True)),
                ('p_update', models.CharField(blank=True, max_length=256, null=True)),
                ('p_delete', models.CharField(blank=True, max_length=256, null=True)),
                ('last_update', models.DateTimeField(blank=True, null=True, verbose_name='Last update')),
                ('classobj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app_data.dataclass')),
            ],
            options={
                'verbose_name': 'Cavaliba Data Instance',
                'verbose_name_plural': 'Cavaliba Data Instances',
                'ordering': ['classobj', 'keyname'],
                'indexes': [models.Index(fields=['classobj'], name='app_data_da_classob_c23de8_idx'), models.Index(fields=['keyname'], name='app_data_da_keyname_f6bb2e_idx'), models.Index(fields=['is_enabled'], name='app_data_da_is_enab_2cf813_idx')],
                'unique_together': {('classobj', 'keyname')},
            },
        ),
        migrations.CreateModel(
            name='DataSchema',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('keyname', models.SlugField(max_length=128)),
                ('displayname', models.CharField(blank=True, max_length=500, null=True)),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='Description')),
                ('is_enabled', models.BooleanField(default=True)),
                ('dataformat', models.CharField(choices=[('string', 'string'), ('int', 'int'), ('float', 'float'), ('boolean', 'boolean'), ('ipv4', 'ipv4'), ('date', 'date'), ('schema', 'schema'), ('group', 'group'), ('user', 'user'), ('datetime', 'datetime'), ('json', 'json'), ('text', 'text'), ('enumerate', 'enumerate'), ('external', 'external')], default='string', max_length=32)),
                ('dataformat_ext', models.CharField(blank=True, max_length=500, null=True)),
                ('default_value', models.CharField(blank=True, default='', max_length=500, null=True)),
                ('page', models.CharField(blank=True, max_length=255, null=True)),
                ('order', models.IntegerField(default=100)),
                ('cardinal_min', models.IntegerField(default=0)),
                ('cardinal_max', models.IntegerField(default=1)),
                ('classobj', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='app_data.dataclass')),
            ],
            options={
                'verbose_name': 'Cavaliba Data Schema',
                'verbose_name_plural': 'Cavaliba Data Schema',
                'ordering': ['classobj', 'keyname', 'order'],
                'unique_together': {('classobj', 'keyname')},
            },
        ),
    ]
