# (c) cavaliba.com - sirene - message_forms.py

from django import forms
from django.utils.translation import gettext as _

from tinymce.widgets import TinyMCE


class SMSForm(forms.Form):

    mobile = forms.CharField(
        max_length=12, 
        required=True,
        widget=forms.TextInput(attrs={'size':20}),
        label = _("Mobile number"),
        help_text = _("Provide a phone numer")
        )


    message  = forms.CharField(
        max_length=128, 
        required=True,
        label = _("Message"),
        widget=forms.Textarea(attrs={"rows":5, "cols":80}),
        )




class MessageUpdateForm(forms.Form):


    has_email = forms.BooleanField(required=False,
        label=_("Send email"),
        initial = False
        )

    has_sms = forms.BooleanField(required=False,
        label=_("Send SMS"),
        initial = False
        )

    sms_content = forms.CharField(max_length=140, required=False,
        label=_("SMS content"),
        widget=forms.Textarea(attrs={'cols':80, 'rows':2})
        #widget=TinyMCE(attrs={'cols': 60, 'rows': 30})
        )


    content = forms.CharField(max_length=5000, required=False,
        label=_("Message"),
        #widget=forms.Textarea(attrs={'cols':80})
        widget=TinyMCE(attrs={'cols': 60, 'rows': 30})
        )
