 # (c) cavaliba.com - sirene - urls.py

from django.urls import path

from . import views

from . import api_views
from . import sms_views




# url namespace
app_name="app_sirene"

urlpatterns = [

    # PUBLIC
    path('', views.index, name='index'),

    # Anonymous / Trusted IPs / No AUTH
    path('anon/'             , views.anon_list,   name='anonymous'),
    path('anon/<int:id>/', views.anon_detail, name='anonymous_detail'),

    # private list/detail
    path('private/', views.private_list, name='private'),
    path('private/detail/<int:id>/', views.private_detail, name='detail'),
    path('private/update/<int:id>/',  views.update, name='update'),
    path('private/close/<int:id>/',  views.close, name='close'),
    path('private/close_all/', views.close_all, name='close_all'),
    path('private/reopen/<int:id>/',  views.reopen, name='reopen'),
    path('private/archive/', views.archive, name='archive'),

    # new message
    path('private/new/',  views.new_message, name='new_message'),
    path('private/new/<int:id>/',  views.new_message, name='new_message'),

    # AJAX endpoints
    path('private/ajax/template-list/', views.template_list_ajax, name='template_list'),
    path('private/ajax/notify-summary/', views.notify_summary_ajax, name='notify_summary'),

    # API
    path('api/', api_views.index, name='api_index'),
    
    # SMS
    path('private/sms/send/', sms_views.sms_send, name='sms_send'),
    path('private/sms/stat/', sms_views.sms_stat, name='sms_stat'),
    path('private/sms/journal/', sms_views.sms_journal, name='sms_journal'),


]
