# (c) cavaliba.com - tests / iam / view

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django

from tests import helper
import app_home.cache as cache

from app_user.models import SireneUser, SireneGroup
from app_user.group import group_get_by_id
from app_user.role import role_get_by_id
from app_user.role import role_get_by_name


class IAMViews(TestCase):

    fixtures = ["init"]


    def setUp(self):
        helper.add_admin_user(login="unittest")
        cache.clear()
        cache_django.clear()

    # def tearDown(self):
    #     super().tearDown()
    #     cache_django.clear()


    # helper
    # def add_user(self, login="testuser01"):
    #     user = SireneUser.objects.create(login=login, firstname=login)
    #     user.save()

    # def add_admin_user(self, login=None):
    #     user = SireneUser.objects.create(login=login, firstname=login)
    #     user.save()
    #     role = role_get_by_name("role_admin")
    #     role.users.add(user)
    #     role.save()

    # def add_group(self, name="testgroup01"):
    #     r = SireneGroup(keyname=name, is_role=False)
    #     r.save()
    #     return r

    # def add_role(self, name="testrole01"):
    #     r = SireneGroup(keyname=name, is_role=True)
    #     r.save()
    #     return r

    # user views
    # ----------

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_private(self):
        response = self.client.get(reverse('app_user:private'), follow=True)
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_debug(self):
        response = self.client.get(reverse('app_user:debug'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_logout(self):
        response = self.client.get(reverse('app_user:logout'), follow=True)
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_list(self):
        response = self.client.get(reverse('app_user:user_list'))
        self.assertEqual(response.status_code, 200)


    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_detail(self):
        # response = self.client.get(
        #   reverse('app_user:user_detail', args=["1"]), follow=True )
        response = self.client.get(
            reverse(
                'app_user:user_detail',
                kwargs={
                    'userid': 1}),
            follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_edit_new(self):
        response = self.client.get(reverse('app_user:user_edit'), follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'csrfmiddlewaretoken')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_edit_1(self):
        response = self.client.get(
            reverse(
                'app_user:user_edit',
                args=[1]),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'csrfmiddlewaretoken')
        # print(response.content)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_edit_post(self):
        # Get the user ID
        user = SireneUser.objects.get(login='unittest')
        user_id = user.id

        # First get the form to obtain CSRF token
        response = self.client.get(
            reverse(
                'app_user:user_edit',
                args=[user_id]),
            follow=True)
        self.assertEqual(response.status_code, 200)

        # POST data to update user
        post_data = {
            'login': 'unittest',
            'firstname': 'Unit',
            'lastname': 'Test',
            'email': 'unittest@example.com',
            'is_enabled': True,
            'is_admin': True,
        }
        response = self.client.post(
            reverse(
                'app_user:user_edit',
                args=[user_id]),
            data=post_data,
            follow=True)
        self.assertEqual(response.status_code, 200)

        # Verify user was updated
        user = SireneUser.objects.get(id=user_id)
        self.assertEqual(user.firstname, 'Unit')
        self.assertEqual(user.lastname, 'Test')
        self.assertEqual(user.email, 'unittest@example.com')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_delete_1(self):
        response = self.client.get(
            reverse(
                'app_user:user_delete',
                args=[1]),
            follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_pref(self):
        response = self.client.get(reverse('app_user:user_pref'), follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_email_test(self):
        response = self.client.get(
            reverse(
                'app_user:email_test',
                args=[1]),
            follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_sms_test(self):
        response = self.client.get(
            reverse(
                'app_user:sms_test',
                args=[1]),
            follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_impersonate(self):
        response = self.client.get(
            reverse('app_user:impersonate'), follow=True)
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_user_impersonate_testuser01(self):
        helper.add_user(login='testuser01')
        response = self.client.get(
            reverse(
                'app_user:impersonate',
                kwargs={
                    'newlogin': 'testuser01'}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'testuser01')



    # group

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_list(self):
        response = self.client.get(reverse('app_user:group_list'))
        self.assertEqual(response.status_code, 200)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_detail(self):
        group = helper.add_group(name="testgroup01")
        response = self.client.get(
            reverse(
                'app_user:group_detail',
                kwargs={
                    'id': group.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, group.keyname)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_edit_new(self):
        response = self.client.get(reverse('app_user:group_edit'), follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'csrfmiddlewaretoken')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_edit(self):
        group = helper.add_group(name="testgroup01")
        response = self.client.get(
            reverse(
                'app_user:group_edit',
                kwargs={
                    'id': group.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, group.keyname)
        response = self.client.get(
            reverse(
                'app_user:group_edit',
                kwargs={
                    'id': 99999999}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'Not allowed')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_edit_post(self):
        group = helper.add_group(name="testgroup01")

        # First get the form to obtain CSRF token
        response = self.client.get(
            reverse(
                'app_user:group_edit',
                kwargs={
                    'id': group.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)

        # POST data to update group
        post_data = {
            'keyname': 'testgroup01',
            'description': 'Updated test group',
            'is_enabled': True,
        }
        response = self.client.post(
            reverse(
                'app_user:group_edit',
                kwargs={
                    'id': group.id}),
            data=post_data,
            follow=True)
        self.assertEqual(response.status_code, 200)

        # Verify group was updated
        updated_group = group_get_by_id(group.id)
        self.assertIsNotNone(updated_group)
        self.assertEqual(updated_group.description, 'Updated test group')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_group_delete_1(self):
        group = helper.add_group(name="testgroup01")
        response = self.client.post(
            reverse(
                'app_user:group_delete',
                kwargs={
                    'id': group.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        group2 = group_get_by_id(group.id)
        self.assertIsNone(group2)



    # role

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_list(self):
        role = helper.add_role(name="testrole01")
        response = self.client.get(reverse('app_user:role_list'))
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, role.keyname)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_detail(self):
        role = helper.add_role(name="testrole01")
        response = self.client.get(
            reverse(
                'app_user:role_detail',
                kwargs={
                    'id': role.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, role.keyname)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_edit_new(self):
        response = self.client.get(reverse('app_user:role_edit'), follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, 'csrfmiddlewaretoken')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_edit(self):
        role = helper.add_role(name="testrole01")
        response = self.client.get(
            reverse(
                'app_user:role_edit',
                kwargs={
                    'id': role.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)
        self.assertContains(response, role.keyname)

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_edit_post(self):
        role = helper.add_role(name="testrole01")

        # First get the form to obtain CSRF token
        response = self.client.get(
            reverse(
                'app_user:role_edit',
                kwargs={
                    'id': role.id}),
            follow=True)
        self.assertEqual(response.status_code, 200)

        # POST data to update role
        post_data = {
            'keyname': 'testrole01',
            'description': 'Updated test role',
            'is_enabled': True,
        }
        response = self.client.post(
            reverse(
                'app_user:role_edit',
                kwargs={
                    'id': role.id}),
            data=post_data,
            follow=True)
        self.assertEqual(response.status_code, 200)

        # Verify role was updated
        updated_role = role_get_by_id(role.id)
        self.assertIsNotNone(updated_role)
        self.assertEqual(updated_role.description, 'Updated test role')

    @override_settings(CAVALIBA_AUTH_MODE="unittest")
    def test_role_delete(self):
        role = helper.add_role(name="testrole01")
        response = self.client.post(
            reverse(
                'app_user:role_delete',
                kwargs={
                    'id': role.id}),
            follow=True)
        # print(response.content)

        self.assertEqual(response.status_code, 200)
        role2 = role_get_by_id(role.id)
        self.assertIsNone(role2)
