---
title: boolean
description: FieldType Boolean
weight: 213
---

Represents a true/false binary value.

## dataformat: boolean

```yaml
  MYFIELD:
      dataformat: boolean
      default_value: false
```

## dataformat_ext

**Not used** - Boolean fields have no extended options. The field type itself is sufficient for true/false values.

## Values

Boolean values accept the following inputs:

- **True**: `true`, `yes`, `1`, `on`, `enabled`
- **False**: `false`, `no`, `0`, `off`, `disabled`

## Multivalue

Multi-value is supported, though less common for boolean fields.

```yaml
## SCHEMA
MYBOOLEANS:
      dataformat: boolean
      cardinal_max: 0

## INSTANCE multi-valued
  MYBOOLEANS: [true, false, true]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: server
  is_active:
    dataformat: boolean
    displayname: Active
    description: Whether server is currently active
```

### Instance Example

```yaml
- classname: server
  keyname: server1
  is_active: true
```

## Notes

- Boolean fields are rendered as checkboxes in edit forms
- Default value is `false` if not specified
- Used extensively for flags, status indicators, and feature toggles
