---
title: file
description: FieldType File
weight: 243
---

Stores and manages file attachments within data instances. Supports uploading, storing, and accessing files.

## dataformat: file

```yaml
  MYFIELD:
      dataformat: file
      default_value: ""
```

## dataformat_ext

**Not used** - File fields have no extended options. All files are stored in the configured filestore location.

## Characteristics

- **File uploads**: Support for user file uploads via UI
- **Storage**: Files stored in Filestore (configurable path)
- **Management**: Upload, download, delete operations
- **Path tracking**: Stores relative file paths

## Multivalue

Multi-value is supported for storing multiple file attachments.

```yaml
## SCHEMA
MYFILES:
      dataformat: file
      cardinal_max: 0

## INSTANCE multi-valued
  MYFILES: [file1.pdf, file2.jpg, file3.xlsx]
```

## Configuration

File storage location configured in environment:

```bash
CAVALIBA_FILESTORE="/app/files/filestore/"
```

Upload size limits configured in Nginx:

```nginx
client_max_body_size 20M;
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: task
  attachment:
    dataformat: file
    displayname: Attachment
    description: Task document or file
```

### Instance Example

```yaml
- classname: task
  keyname: task001
  attachment: "task_spec.pdf"
```

## Storage Location

Files stored in: `/app/files/filestore/`

- Relative paths stored in field
- Full path: `{CAVALIBA_FILESTORE}/{relative_path}`
- Can be mounted to persistent volumes for backups

## Notes

- Filestore feature is in ALPHA (introduced in v3.19.0)
- Maximum upload size: 20MB (configurable in nginx.conf)
- Supports any file type
- Files should be backed up separately
- Relative paths allow portable backups and migrations
- Related to backup and data export operations
- Use scripts/ directory for backup utilities
