---
title: time
description: FieldType Time
weight: 216
---

Represents a time value (hours, minutes, seconds) without date information.

## dataformat: time

```yaml
  MYFIELD:
      dataformat: time
      default_value: "09:00:00"
```

## dataformat_ext

**Not used** - Time fields have no extended options. ISO 8601 24-hour format (HH:MM:SS) is always used.

## Format

Time values are stored and displayed in ISO 8601 format: **HH:MM:SS**

Examples:
- 09:00:00
- 14:30:45
- 23:59:59

## Multivalue

Multi-value is supported for storing multiple times.

```yaml
## SCHEMA
BUSINESSHOURS:
      dataformat: time
      cardinal_max: 0

## INSTANCE multi-valued
  BUSINESSHOURS: [09:00:00, 17:00:00]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: office
  opening_time:
    dataformat: time
    displayname: Opening Time
    description: Time office opens
```

### Instance Example

```yaml
- classname: office
  keyname: main_office
  opening_time: "08:00:00"
```

## Notes

- Time picker widget provided in edit forms
- ISO 8601 24-hour format (HH:MM:SS) is standard
- No date component included (use `date` or `datetime` if needed)
- Useful for scheduling, business hours, and time-based rules
- Comparisons work on time of day only
