---
title: user
description: FieldType User
weight: 230
---

References one or more Cavaliba user accounts. Allows linking data to specific users.

## dataformat: user

```yaml
  MYFIELD:
      dataformat: user
```

## dataformat_ext

**Not used** - User fields have no extended options. The field automatically references all users in the system.

## Values

Field contains user logins as strings. References SireneUser objects in the system.

- Values: User login identifiers (e.g., `john.smith`, `admin`)
- Can lookup by email during import (e.g., `john@company.com`)

## Multivalue

Multi-value is supported and commonly used for assigning multiple users.

```yaml
## SCHEMA
ASSIGNEES:
      dataformat: user
      cardinal_max: 0

## INSTANCE multi-valued
  ASSIGNEES: [john.smith, jane.doe, admin]
```

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: task
  assigned_to:
    dataformat: user
    displayname: Assigned To
    description: Task assignment user
```

### Instance Example

```yaml
- classname: task
  keyname: task001
  assigned_to: john.smith
```

## Notes

- Field references actual users in the system (SireneUser model)
- Users can be looked up by login or email during import
- Useful for assignment, approval workflows, and notifications
- Related to IAM system and permission management
- User objects provide displayname, email, and other attributes
