---
title: App Configuration
description: Application Configuration Options
weight: 20
---

From the Cavaliba Web UI with appropriate permissions, you can configure many parameters and options for a cavaliba deployment.

![config](app_configuration.png)

This page explains all configuration options accessible through the Configuration section.

## Usage

* Use the `Configuration` entry in the sidebar.
* Navigate to the desired configuration section.
* Don't forget to save after modifying an option.
* Effect is immediate. No reload/no restart needed.

**Permission needed:** `p_conf_admin`

---

## HOME - Global Application Settings

### GLOBAL_APPNAME
**Default:** `Cavaliba`

The main application name displayed as the top link in the sidebar and throughout the interface.
Customize this to match your organization name. Example: `MyCompany IT Portal` or `Infrastructure Hub`.

### CSV_DELIMITER
**Default:** `;`

Default column separator character for CSV files during import/export operations if not specified in the pipeline.
Common values are `;` (semicolon) or `,` (comma). Used when auto-detecting CSV structure.

### LOGO_SIZE
**Default:** `0`

Width in pixels for displaying a company logo in the sidebar. Set to `0` to disable logo and show app name instead.
Logo file should be placed at `/app/files/logo/logo.png`. Recommended size: 200-300 pixels wide.

### LOG_KEEP_DAYS_DEBUG
**Default:** `7`

Number of days to retain DEBUG level log entries in the database for interactive access in the Web UI.
A daily housekeeping task automatically purges logs older than this value. Example: Set to `14` for 2 weeks of DEBUG logs.

### LOG_KEEP_DAYS_INFO
**Default:** `120`

Number of days to retain INFO level log entries in the database for interactive access in the Web UI.
A daily housekeeping task automatically purges logs older than this value. Example: Set to `365` for a full year of INFO logs.

### LOG_KEEP_DAYS_WARNING
**Default:** `365`

Number of days to retain WARNING level log entries in the database for interactive access in the Web UI.
A daily housekeeping task automatically purges logs older than this value. Example: Keep at `365` for compliance audit trails.

### LOG_KEEP_DAYS_ERROR
**Default:** `365`

Number of days to retain ERROR level log entries in the database for interactive access in the Web UI.
A daily housekeeping task automatically purges logs older than this value. Example: Increase to `730` for 2 years of error history.

### LOG_KEEP_DAYS_CRITICAL
**Default:** `99999`

Number of days to retain CRITICAL level log entries in the database for interactive access in the Web UI.
A daily housekeeping task purges logs older than this value. The high default (99999 days) effectively keeps critical logs indefinitely.

### LOG_MAX_ENTRIES
**Default:** `2200000`

Maximum total number of log entries to maintain across all log levels in the database.
When the total exceeds this limit, oldest logs are purged regardless of retention settings. Prevents database overflow.

### LOG_EXCLUDED_IP
**Default:** `` (empty)

Space-separated list of IP addresses to exclude from logging to prevent cluttering logs with monitoring/health checks.
Example: `192.168.1.50 10.0.0.100` excludes these monitoring servers from appearing in logs.

### LOG_DEBUG
**Default:** `yes`

Enable or disable DEBUG level logging in the application.
When set to `no`, DEBUG messages are not recorded even if the application generates them. Useful for reducing log volume in production.

### SIDEBAR_ENV
**Default:** `` (empty)

Label for the environment displayed prominently in the sidebar to help users identify which environment they're using.
Examples: `PROD`, `TEST`, `DEV`, or `STAGING`. Combine with `SIDEBAR_COLOR` for visual identification.

### SIDEBAR_COLOR
**Default:** `#000000`

Sidebar background color in hexadecimal RGB format to provide visual environment identification.
Examples: `#FF0000` (red for production), `#FFAA00` (orange for staging), `#00AA00` (green for test/dev).

### REVISION_DISPLAY
**Default:** `10`

Number of revision/audit events to display in the data change history UI for each data instance.
Shows recent changes in chronological order. Increase if you want to see more history on the detail page. Example: Set to `50` to see 50 recent changes.

### REVISION_KEEP_DAYS
**Default:** `999`

Number of days to retain revision/audit events in the database before automatic deletion.
A daily housekeeping task purges older revision records. Example: Set to `365` to keep exactly one year of audit trail.

### BETA_PREVIEW
**Default:** `no`

Enable or disable beta/preview features that may be unstable or incomplete.
When set to `yes`, shows experimental features currently in development. Disabled by default for stability and reliability.

---

## USER - User Authentication and Session Settings

### CACHE_SESSION
**Default:** `yes`

Use Redis cache for user session storage to improve performance and enable sessions across multiple instances.
When enabled, requires Redis connectivity. When disabled, sessions are stored in the database (slower but works standalone).

### TRUSTED_ANONYMOUS_IPS
**Default:** `` (empty)

Comma-separated list of IP addresses or CIDR blocks that are allowed anonymous access to public pages without authentication.
Example: `192.168.1.0/24 10.0.0.0/8` allows these subnets anonymous access. CIDR notation is supported.

### AUTH_LOGIN_REMOVE_DOMAIN
**Default:** `yes`

Automatically strip domain name from federated login usernames during authentication.
When enabled, `john.smith@company.com` becomes `john.smith`. Useful when domain is standardized across users.

### AUTH_FEDERATED_LOGIN_FIELD
**Default:** `X-User`

HTTP header name that contains the authenticated username from the identity provider or reverse proxy.
The OAuth2 proxy or reverse proxy sets this header. Example: `Remote-User` if using Apache auth module.

### AUTH_FEDERATED_EMAIL_FIELD
**Default:** `X-Email`

HTTP header name that contains the email address from the identity provider or reverse proxy.
Used to populate user email during just-in-time provisioning. Example: `X-Remote-User-Email` if using custom proxy.

### AUTH_PROVISIONING
**Default:** `manual`

User account provisioning strategy for federated authentication. Options: `manual`, `visitor`, `create`, `update`, `sync`.
- `manual`: No auto-provisioning, users must exist in Cavaliba
- `visitor`: Temporary access without creating permanent account
- `create`: Create new user account with basic role
- `update`: Update existing user attributes from IdP
- `sync`: Full sync of user attributes and groups

---

## DATA - Data Management and Pagination Settings

### DATA_DEFAULT_SIZE
**Default:** `200`

Default number of data records displayed per page in data listings and search results.
Users can override this in the UI. Higher values mean less pagination but longer initial load. Example: Set to `100` for slower connections.

### DATA_MAX_SIZE
**Default:** `500`

Maximum number of records that can be requested per page in data listings to prevent performance issues.
Prevents users from requesting excessively large result sets. Set to `1000` if you have powerful servers.

### DATA_BIGSET_SIZE
**Default:** `500`

Threshold above which data listings switch to partial loading with AJAX pagination for performance.
When a dataset exceeds this size, only visible rows load initially. Set to `1000` for better performance with very large datasets.

### EXPORT_INTERACTIVE_MAX_SIZE
**Default:** `5000`

Maximum dataset size for interactive export via the web UI (CSV/Excel/JSON download).
Larger datasets cannot be exported interactively but can be exported via API or batch commands. Example: Set to `10000` for more generous limits.

---

## SIRENE - Notification System Settings

### SIRENE_APPNAME
**Default:** `Sirene`

Display name for the Sirene notification/alerting system shown on public status pages and in the UI.
Customize to match your organization branding. Example: `MyCompany Alerts` or `Infrastructure Notifications`.

### PUBLIC_MAX_ITEMS
**Default:** `6`

Maximum number of public incident messages displayed on the public status page.
Shows most recent/active incidents first. Limiting this improves page load time. Example: Set to `10` to show more incidents.

### DEFAULT_DURATION_MINUTE
**Default:** `1440`

Default duration in minutes before notifications auto-archive if not manually updated (1440 = 24 hours).
After this period, active incidents are automatically moved to archived status. Example: Set to `60` for 1-hour auto-archive.

### PUBLIC_SORT_ORDER
**Default:** `creation`

Sort order for public messages: `creation` (newest first) or `severity` (most critical first).
Determines what users see first on the public status page. Example: Use `severity` to highlight critical issues.

### PUBLIC_SKIP_TO_TRUSTED
**Default:** `no`

Skip the public status page for users from trusted IP addresses, redirect directly to authenticated status view.
When enabled, trusted users bypass the public page. Useful when public page is less detailed than authenticated view.

### USER_MAX_NOTIFICATION
**Default:** `100`

Maximum number of users per notification distribution in a single batch to prevent queue overload.
Notifications with more recipients are split into multiple batches. Example: Set to `50` for smaller batches on slower systems.

### EMAIL_MAX_NOTIFICATION
**Default:** `100`

Maximum number of email addresses per notification send operation to manage SMTP server load.
Large email distributions are split into multiple batches. Example: Set to `25` if your SMTP server has strict limits.

### EMAIL_MODE
**Default:** `stdout`

Email delivery method: `stdout` (logs to console), `folder` (writes to files), or `smtp` (sends via mail server).
Use `stdout`/`folder` for testing. Switch to `smtp` in production with proper `CAVALIBA_EMAIL_HOST` configuration.

### EMAIL_FOLDER
**Default:** `/app/files/mail/`

File system path where email files are written in `folder` mode for testing or external mail system integration.
Directory must be writable by the application. Example: `/var/log/cavaliba_mail/` for centralized email log location.

### EMAIL_FROM
**Default:** `noreply@findadomain.com`

Source email address displayed to recipients as the sender of notification emails.
Must be a valid email format. Example: `alerts@company.com` or `notifications@mydomain.org`.

### EMAIL_SMTP_BATCH
**Default:** `100`

Maximum email recipients per SMTP connection to manage resource usage and prevent connection timeouts.
Improves efficiency by grouping recipients. Example: Set to `50` if SMTP server disconnects with larger batches.

### EMAIL_PREFIX
**Default:** `[Cavaliba] `

Prefix automatically added to the subject line of new incident notification emails.
Helps users filter and identify incident emails in their inbox. Example: `[MyCompany Alert] ` or `[ALERT] `.

### EMAIL_UPDATE_PREFIX
**Default:** `[Cavaliba Update] `

Prefix added to the subject line of incident update notification emails to distinguish from initial notifications.
Helps users track which emails are updates vs. new incidents. Example: `[MyCompany Update] ` or `[UPDATE] `.

### EMAIL_TEST_SUBJECT
**Default:** `Cavaliba - TEST TEST TEST - Please ignore.`

Subject line used when sending test email messages to verify email configuration is working.
Should clearly indicate it's a test to avoid confusion. Example: `TEST Email Configuration - Ignore`.

### EMAIL_TEST_CONTENT
**Default:** `Test.Ignore.`

Email body content for test messages when verifying email system configuration.
Keep it brief and clear that it's a test. Example: `This is a test email from Cavaliba. Please ignore.`

### SMS_MAX_NOTIFICATION
**Default:** `30`

Maximum number of SMS recipients per notification batch to manage SMS provider rate limits.
SMS providers typically have strict rate limits. Example: Set to `10` for conservative rate limiting.

### SMS_QUOTA_PER_DAY
**Default:** `100`

Maximum number of SMS messages per user per 24-hour period to prevent user overload.
Applied per recipient, not globally. Helps prevent notification fatigue. Example: Set to `50` for stricter limits.

### SMS_MODE
**Default:** `stdout`

SMS delivery method: `stdout` (logs to console), `folder` (writes to files), or `clicsecure` (SMS provider API).
Use `stdout`/`folder` for testing. Switch to `clicsecure` in production with proper SMS provider credentials.

### SMS_FOLDER
**Default:** `/app/files/sms/`

File system path where SMS files are written in `folder` mode for testing or external SMS system integration.
Directory must be writable by the application. Example: `/var/log/cavaliba_sms/` for centralized SMS log location.

### SMS_PREFIX
**Default:** `[Cavaliba] `

Prefix added to SMS text messages for new incidents to identify the source system.
Keep short since SMS has character limits. Example: `[ALERT] ` for brevity.

### SMS_UPDATE_PREFIX
**Default:** `[Cavaliba Update] `

Prefix added to SMS text messages for incident updates to distinguish from initial alerts.
Keep concise due to SMS character limits. Example: `[UPDATE] ` for a shorter prefix.

### SMS_TEST
**Default:** `Cavaliba - TEST TEST TEST - Please ignore.`

Test message content sent when verifying SMS configuration is working.
Should be brief and clearly marked as a test. Example: `TEST SMS from Cavaliba - Ignore`

### SMS_WARNING
**Default:** `IMPORTANT: All SMS activity is recorded for security purposes.`

Warning message included in SMS notifications to inform recipients of logging/recording.
Legal/compliance requirement in some jurisdictions. Example: `Note: This message is logged for compliance.`

### NOTIFY_FIELDS
**Default:** `user group app site`

Schema field names that define notification targets in the data schema for triggering notifications.
These fields must exist in your schemas. Example: `notify_user notify_admin notify_site` if using custom names.

### NOTIFY_SUBSCRIPTIONS
**Default:** `site:app`

Schema relationships for automatic notification propagation using parent:child notation.
Notifications propagate from child to parent following these relationships. Example: `app:service site:app customer:site` for multi-level propagation.

---

## STATUS - Status Monitoring Settings

### STATUS_APPNAME
**Default:** `StatusPage`

Display name for the Status Monitoring application shown on public pages and UI navigation.
Customize to match your organization branding. Example: `Infrastructure Status` or `System Health Monitor`.

### STATUS_RAW_KEEP_DAYS
**Default:** `7`

Number of days to retain raw detailed status check results in the database.
Raw data provides minute-by-minute history. Daily housekeeping purges older data. Example: Set to `14` for 2 weeks of detailed data.

### STATUS_SAMPLE_HOUR_KEEP_DAYS
**Default:** `31`

Number of days to retain hourly aggregated status sample data in the database for trend analysis.
Hourly samples provide summarized trends with lower storage impact. Retained longer than raw data for long-term analysis.

---

## IPAM - IP Address Management Settings

### IPAM_APPNAME
**Default:** `IPAM - IP Management`

Display name for the IPAM (IP Address Management) application shown in navigation and public-facing interfaces.
Customize to match your organization naming conventions. Example: `IP Address Management` or `Network Planning`.
