---
title: CLI (local)
description: Local Command Line tools
weight: 710
---


## Local Management commands

If you have access to the server/VM hosting your cavaliba system, you can use the built-in management commands from the Django/Docker frameworks.

First, create these 2 aliases for easy access:

    ### add to your .bashrc for persistence
    $ alias cavaliba="docker exec -it cavaliba_app python manage.py cavaliba"
    $ alias cavmanage="docker exec -it cavaliba_app python manage.py"

The `cavaliba`command starts a custom Django command to perform various tasks and queries agains the cavaliba system.

The `cavmanage`command will give access to Django built-in  management framework for system oriented tasks.

You can now type : 

    $ cavmanage
    $ cavaliba --help


You'll see all available commands.



**version**

    $ cavaliba version
    3.17.1

**Load schema and data**


    $ cavaliba load /files/demo/
    $ cavaliba load /files/demo/100_site.yaml --pass 2

Note: absolute folder for /files, inside containers ; local folder is files/ on host.


**Load CSV data file**

$ cavaliba load /files/demo/user/user.csv --pipeline user_import_csv

A pipeline is needed to map columns to Schema fields and usually apply some transformations.

**multipass**

    --pass 2

The `--pass` option is recommanded for schema, because cross-references between schemas requires some schemas to be created before others. Multiple pass resolve dependencies.


**progress**

Display progression for large files :

    --progress 

    File: /files/import/user.csv ...
    Found: 55456 objects
    Pipeline: user_import_csv
    Loading to DB...
    100 done
    200 done
    (...)


**first/last**

Choose quantity (first/last lines to process) ; 0 for last is unlimited.

    --first 1 
    --last 0


**log view**

    $ cavaliba log
    $ cavaliba log --first 0 --last 1000

**log purge**

apply automatic log purge:

    $ cavaliba log --log_purge
    log entries: 203718
    log deleted (old) : 48 entries
    log done

purge all logs (!):

    $ cavaliba log --log_purge_all
    log entries: 203676
    log deleted (all) : 203676 entries
    log done


**conf view**

    $ cavaliba conf
    $ cavaliba conf --text
    $ cavaliba conf --json
    $ cavaliba conf --yaml
    $ cavaliba conf --yaml --key LOG_KEEP_DAYS_ERROR


**conf sync**

Creates default entries / purge orphan. Run automatically during startup.

    $ cavaliba conf --confsync --verbose


**conf backup/restore**

Backup conf:

    $ cavaliba conf > files/export/conf_backup.json

Reload conf (from container accessible folder)

    $ cavaliba conf --conf_file /files/export/conf_backup.json --verbose

**data query/export**

Get available schemas:

    $ cavaliba schema

Query a schema:

    $ cavaliba schema --schema user 
    - login: admin
      displayname: Built-in Global Admin user
      is_enabled: true
      want_notifications: true
      want_24: true
      want_email: true
      classname: _user

    - login: i.trento
      displayname: Izongua Trento
      is_enabled: true
      want_notifications: true
      want_24: true
      want_email: true
      classname: _user

      (...)


Query a schema and a specific object:

    $ cavaliba cavaliba_export --schema user --key testuser01
    - login: testuser01
      email: testuser01@test.com
      mobile: 0123456789
      displayname: Test User 01
      description: Test User 01
      is_enabled: true
      want_notifications: true
      want_24: true
      want_sms: true
      want_email: true
      classname: _user

Specify an output format:

    $ cavaliba cavaliba_export --schema site --key testsite01 --json
    [
        {
            "classname": "site",
            "keyname": "testsite01",
            "displayname": "Test Site 01",
            "p_read": null,
            "p_update": null,
            "p_delete": null,
            "is_enabled": true,
            "sirene_group": [
                "testgroup01"
            ]
        }
    ]



**Run the integrated test suite**

First, either create an empty test database in your database server or use the `root` DµB user in your docker `.env` file for variable `CAVALIBA_DB_USER`. Alternatively you may prefer to grant create database privileges to your current CAVALIBA_DB_USER.

Then, 

    $ cavmanage test


Options exists such as:

    $ cavmanage test --keepdb
    $ cavmanage test -v 2
    $ cavmanage test --keepdb app_home.tests.test_home.ConfTest

You may need to create a test database manually in MariaDB. Example:

    docker exec -it cavaliba_db mysql -u root -p
    create database test_cavaliba;
    show grants for 'cavaliba';
    GRANT ALL PRIVILEGES ON `test_cavaliba`.* TO `cavaliba`@`%`;
    flush privileges;