#!/bin/bash
#set -eux
set -o pipefail

# (c) cavaliba.com - DB backup script
#
# crontab example
# 25 */6 * * * /opt/cavaliba/script/db_backup.sh > /tmp/backup_db.log 2>&1

# configure here
BACKUPDIR="/opt/cavaliba/files/backup"
USER="root"
PASSWORD="xxxxxxxxxxxxxxxxxxxx"

# ---
cd $BACKUPDIR

DAY=$(date "+%u")
HOUR=$(date "+%H")
FILE="$BACKUPDIR/${DAY}_${HOUR}_dbdump.zst"

DATE=$(date +%Y%m%d_%H:%M:%S)
echo "$DATE start dumping DB to $FILE"

#docker exec cavaliba_db pg_dump cavaliba -U $USER |zstd > $FILE
docker exec cavaliba_db mysqldump -u $USER -p$PASSWORD cavaliba |zstd > $FILE

DATE=$(date +%Y%m%d_%H:%M:%S)
echo "$DATE done."
exit 0
