# (c) cavaliba.com  - data/api - testapi.py

import json

from django.http import HttpResponse
from django.views.decorators.csrf import csrf_exempt

from app_home.log import log, DEBUG, INFO, WARNING, ERROR, CRITICAL

from app_user.aaa_api import start_api
import app_data.api.helper as helper



#  ----------------------------------------------------------------------------
# /api/test/
#  ----------------------------------------------------------------------------
@csrf_exempt
def testapi(request):

    aaa_api = start_api(request, permission="p_info")
    if not aaa_api["is_allowed"]:
        return helper.send_denied()

    log(DEBUG, aaa=aaa_api, app="api", view="test", action="GET", status="OK", data="")


    reply = {"test": "OK"}

    #time.sleep(5)
    #return helper.send_response(request, reply, 200)


    content = json.dumps(reply, indent=2, ensure_ascii=False).encode('utf8')
    content_type = 'application/json; charset=utf-8'
    return HttpResponse(content + b"\n", status=200, content_type=content_type)
