# Generated by Django 5.0.4 on 2025-02-12 16:50

import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('app_data', '0001_initial'),
        ('app_user', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Category',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(default='na', max_length=128, unique=True, verbose_name='Name')),
                ('longname', models.CharField(blank=True, max_length=128, verbose_name='Display name')),
                ('description', models.CharField(blank=True, max_length=500, verbose_name='Description')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'verbose_name': 'Category',
                'verbose_name_plural': 'Categories',
                'ordering': ['id'],
            },
        ),
        migrations.CreateModel(
            name='PublicPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(max_length=128, unique=True, verbose_name='Name')),
                ('title', models.CharField(blank=True, max_length=250, verbose_name='Title')),
                ('body', models.TextField(blank=True, max_length=2500, verbose_name='Text')),
                ('severity', models.CharField(choices=[('na', 'n/a'), ('critical', 'critical'), ('major', 'major'), ('minor', 'minor'), ('info', 'info'), ('other', 'other'), ('ok', 'ok')], default='na', max_length=20, verbose_name='Severity')),
                ('is_default', models.BooleanField(default=False, verbose_name='Default Public Page')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
            ],
            options={
                'verbose_name': 'Public Page',
                'verbose_name_plural': 'Public Pages',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='PublicPageJournal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(max_length=128, verbose_name='Name')),
                ('title', models.CharField(blank=True, max_length=250, verbose_name='Title')),
                ('body', models.TextField(blank=True, max_length=2500, verbose_name='Text')),
                ('severity', models.CharField(choices=[('na', 'n/a'), ('critical', 'critical'), ('major', 'major'), ('minor', 'minor'), ('info', 'info'), ('other', 'other'), ('ok', 'ok')], default='na', max_length=20, verbose_name='Severity')),
                ('is_default', models.BooleanField(default=False, verbose_name='Default Public Page')),
                ('is_visible', models.BooleanField(db_index=True, default=True, verbose_name='Is visible')),
                ('created_at', models.DateTimeField(db_index=True, verbose_name='Created at')),
                ('created_by', models.CharField(blank=True, max_length=200, verbose_name='Created by')),
                ('removed_at', models.DateTimeField(blank=True, null=True, verbose_name='Removed at')),
                ('removed_by', models.CharField(blank=True, default='auto', max_length=200, verbose_name='Removed by')),
            ],
            options={
                'verbose_name': 'Public Page Journal',
                'verbose_name_plural': 'Public Pages Journal',
                'ordering': ['name'],
            },
        ),
        migrations.CreateModel(
            name='SMSJournal',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Created at')),
                ('created_by', models.CharField(blank=True, max_length=200, verbose_name='Created by')),
                ('mobile', models.CharField(blank=True, max_length=32, null=True, verbose_name='Mobile')),
                ('content', models.TextField(blank=True, max_length=5000, verbose_name='Content')),
                ('quota', models.IntegerField(blank=True, null=True, verbose_name='Quota left')),
            ],
            options={
                'verbose_name': 'SMS Journal',
                'verbose_name_plural': 'SMS Journal',
                'ordering': ['created_at'],
            },
        ),
        migrations.CreateModel(
            name='Message',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('category', models.CharField(blank=True, default='?', max_length=128, verbose_name='Category')),
                ('severity', models.CharField(choices=[('na', 'n/a'), ('critical', 'critical'), ('major', 'major'), ('minor', 'minor'), ('info', 'info'), ('other', 'other'), ('ok', 'ok')], default='na', max_length=20, verbose_name='Severity')),
                ('title', models.CharField(blank=True, max_length=250, verbose_name='Title')),
                ('body', models.TextField(blank=True, max_length=5000, verbose_name='Message')),
                ('publicpage_text', models.TextField(blank=True, max_length=2500, verbose_name='Public page text')),
                ('has_publicpage', models.BooleanField(default=False, verbose_name='Private Page')),
                ('has_privatepage', models.BooleanField(default=False, verbose_name='Private Page')),
                ('has_email', models.BooleanField(default=False, verbose_name='Email')),
                ('has_sms', models.BooleanField(default=False, verbose_name='SMS')),
                ('email_count', models.IntegerField(default=0, verbose_name='Emails sent')),
                ('sms_count', models.IntegerField(default=0, verbose_name='SMS sent')),
                ('is_visible', models.BooleanField(db_index=True, default=True, verbose_name='Visible')),
                ('template', models.CharField(blank=True, max_length=80, verbose_name='Template')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='Created at')),
                ('updated_at', models.DateTimeField(blank=True, db_index=True, null=True, verbose_name='Updated at')),
                ('removed_at', models.DateTimeField(blank=True, null=True, verbose_name='Removed at')),
                ('created_by', models.CharField(blank=True, max_length=200, verbose_name='Created by')),
                ('updated_by', models.CharField(blank=True, max_length=200, verbose_name='Updated by')),
                ('removed_by', models.CharField(blank=True, max_length=200, verbose_name='Removed by')),
                ('notify_text', models.TextField(blank=True, verbose_name='Message (text)')),
                ('users_text', models.TextField(blank=True, verbose_name='Users (text)')),
                ('notify_app', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_customer', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_group', models.ManyToManyField(blank=True, related_name='+', to='app_user.sirenegroup')),
                ('notify_site', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_sitegroup', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('users', models.ManyToManyField(blank=True, related_name='+', to='app_user.sireneuser')),
                ('publicpage', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app_sirene.publicpagejournal')),
            ],
            options={
                'verbose_name': 'Message',
                'verbose_name_plural': 'Messages',
                'ordering': ['created_at', 'severity'],
            },
        ),
        migrations.CreateModel(
            name='MessageUpdate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('content', models.TextField(blank=True, max_length=5000, verbose_name='Message')),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, verbose_name='created at')),
                ('created_by', models.CharField(blank=True, max_length=200, verbose_name='created by')),
                ('has_email', models.BooleanField(default=False, verbose_name='Email')),
                ('has_sms', models.BooleanField(default=False, verbose_name='SMS')),
                ('message', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='updates', to='app_sirene.message')),
            ],
            options={
                'verbose_name': 'Message Update',
                'verbose_name_plural': 'Message Updates',
                'ordering': ['created_at', 'created_by'],
            },
        ),
        migrations.CreateModel(
            name='MessageTemplate',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.SlugField(max_length=128, unique=True, verbose_name='Name')),
                ('severity', models.CharField(choices=[('na', 'n/a'), ('critical', 'critical'), ('major', 'major'), ('minor', 'minor'), ('info', 'info'), ('other', 'other'), ('ok', 'ok')], max_length=20, verbose_name='Severity')),
                ('is_enabled', models.BooleanField(default=True, verbose_name='Enabled')),
                ('title', models.CharField(blank=True, max_length=250, verbose_name='Title')),
                ('body', models.TextField(blank=True, max_length=5000, verbose_name='Message')),
                ('description', models.TextField(blank=True, max_length=2500, verbose_name='Description')),
                ('has_publicpage', models.BooleanField(default=False, verbose_name='Public Page')),
                ('has_privatepage', models.BooleanField(default=False, verbose_name='Private Page')),
                ('has_email', models.BooleanField(default=False, verbose_name='Email')),
                ('has_sms', models.BooleanField(default=False, verbose_name='SMS')),
                ('category', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='app_sirene.category')),
                ('notify_app', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_customer', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_group', models.ManyToManyField(blank=True, related_name='+', to='app_user.sirenegroup')),
                ('notify_site', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('notify_sitegroup', models.ManyToManyField(blank=True, related_name='+', to='app_data.datainstance')),
                ('publicpage', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='app_sirene.publicpage')),
            ],
            options={
                'verbose_name': 'MessageTemplate',
                'verbose_name_plural': 'MessageTemplates',
                'ordering': ['name'],
            },
        ),
    ]
