# (c) cavaliba.com - app_status - admin.py

from django.contrib import admin

from app_status.models import StatusRaw
from app_status.models import StatusSampleHour
from app_status.models import StatusSampleDay


@admin.register(StatusRaw)
class StatusRawAdmin(admin.ModelAdmin):
    list_display = ('timestamp', 'monitor', 'status', 'usec', 'data', 'id')
    ordering = ["-timestamp"]
    list_filter = ["monitor"]



@admin.register(StatusSampleHour)
class StatusSampleHourAdmin(admin.ModelAdmin):
    list_display = ('timestamp', 'monitor', 'count_ok', 'count_ko', 'id')
    ordering = ["-timestamp"]
    list_filter = ["monitor"]


@admin.register(StatusSampleDay)
class StatusSampleDayAdmin(admin.ModelAdmin):
    list_display = ('timestamp', 'monitor', 'count_ok', 'count_ko', 'id')
    ordering = ["-timestamp"]
    list_filter = ["monitor"]