# (c) cavaliba.com - app_status - views.py



from django.shortcuts import render, redirect



from app_home.log import log, DEBUG
from app_user.aaa import start_view

from app_status.common import get_monitor
from app_status.common import get_monitors
from app_status.common import compute_live_status

from app_status.common import compute_hourly_ratio
from app_status.common import compute_hourly_bargraph

from app_status.common import compute_daily_ratio
from app_status.common import compute_daily_bargraph

from app_status.common import compute_monthly_ratio
from app_status.common import compute_monthly_bargraph

from app_status.common import compute_quaterly_ratio
from app_status.common import compute_quaterly_bargraph

from app_status.common import compute_yearly_ratio
from app_status.common import compute_yearly_bargraph


# -----------------------------------------------
# private - monitor list
# -----------------------------------------------


def list(request):

    context = start_view(request, app="status", view="private", noauth="app_sirene:index",
                         perm="p_status_access", noauthz="app_home:private")

    if context["redirect"]:
        return redirect(context["redirect"])
    aaa = context["aaa"]


    monitors = get_monitors()

    # run_monitors(monitors=monitors)

    compute_live_status(monitors=monitors)
    compute_hourly_ratio(monitors=monitors)
    compute_daily_ratio(monitors=monitors)
    compute_monthly_ratio(monitors=monitors)
    compute_quaterly_ratio(monitors=monitors)
    compute_yearly_ratio(monitors=monitors)



    monitorgroups = [{'displayname': 'ALL', 'monitors': monitors}]
    context['monitorgroups'] = monitorgroups

    log(DEBUG, aaa=aaa, app="status", view="private", action="access", status="OK", data="")
    return render(request, 'app_status/list.html', context)




# -----------------------------------------------
# detail - display monitor detail bargraph
# -----------------------------------------------


def detail(request, monitor_name=None):

    context = start_view(request, app="status", view="detail", noauth="app_sirene:index",
                         perm="p_status_access", noauthz="app_home:private")

    if context["redirect"]:
        return redirect(context["redirect"])
    aaa = context["aaa"]

    # monitors = get_monitors()
    # #run_monitors(monitors=monitors)
    # sample_hour(monitors=monitors, start_date = timezone.now() - timedelta(days=2))
    # sample_day(monitors=monitors, start_date = timezone.now() - timedelta(days=2))
    # cleanup_raw(monitors=monitors)
    # cleanup_hour(monitors=monitors)




    monitor = get_monitor(monitor_name)
    compute_live_status(monitors=[monitor])

    compute_hourly_ratio(monitors=[monitor])
    compute_hourly_bargraph(monitors=[monitor])

    compute_daily_ratio(monitors=[monitor])
    compute_daily_bargraph(monitors=[monitor])

    compute_monthly_ratio(monitors=[monitor])
    compute_monthly_bargraph(monitors=[monitor])

    compute_quaterly_ratio(monitors=[monitor])
    compute_quaterly_bargraph(monitors=[monitor])

    compute_yearly_ratio(monitors=[monitor])
    compute_yearly_bargraph(monitors=[monitor])



    log(DEBUG, aaa=aaa, app="status", view="private", action="detail", status="OK", data="")

    context['monitor'] = monitor
    return render(request, 'app_status/detail.html', context)
