# (c) cavaliba.com - test_home

from io import StringIO
# import io

from django.test import override_settings
from django.test import TestCase
from django.test import TransactionTestCase
from django.urls import reverse
from django.core.cache import cache as cache_django
from django.core.management import call_command

from tests import helper

import app_home.cache as cache
from app_home.configuration import get_configuration


class ConfTest(TestCase):

    fixtures = ["init"]

    def setUp(self):
        cache.clear()

    def test_test(self):
        self.assertEqual(True, True)

    def test_get_configuration(self):

        r = get_configuration("home", "GLOBAL_APPNAME")
        self.assertEqual(r, 'Cavaliba')

        r = get_configuration(keyname="GLOBAL_APPNAME")
        self.assertEqual(r, 'Cavaliba')

        r = get_configuration("env", "CAVALIBA_AUTH_MODE")
        # self.assertEqual(r, 'local')
        self.assertIn(r, ["local", "oauth2", "basic", "forced"])

    def test_conf_no_skip_public(self):
        r = get_configuration("sirene", "PUBLIC_SKIP_TO_TRUSTED")
        self.assertEqual(r, 'no')

    # ------------
    # commands
    # ------------
    def test_check_command(self):

        output = StringIO()
        StringIO()
        call_command("check", verbosity=2, stdout=output)
        assert ("System check identified no issues" in output.getvalue())

    def test_init_command(self):

        output = StringIO()
        StringIO()
        call_command("cavaliba", "init", verbosity=2, stdout=output)
        assert ("init done" in output.getvalue())

    def test_conf_command(self):

        output = StringIO()
        StringIO()
        call_command("cavaliba", "conf", verbosity=2, stdout=output)
        assert ("GLOBAL_APPNAME" in output.getvalue())


    def test_log_purge_command(self):

        output = StringIO()
        StringIO()
        call_command(
            "cavaliba",
            "log",
            "--log_purge",
            verbosity=2,
            stdout=output)
        assert ("log done" in output.getvalue())


    def test_load_command_unknown(self):

        output = StringIO()
        err = StringIO()
        call_command(
            "cavaliba",
            "load",
            "unknown_file",
            verbosity=2,
            stdout=output,
            stderr=err)
        assert ("load done" in output.getvalue())
        assert ("SKIP - Unknown filename" in err.getvalue())
