---
title: Sirene - Models
description: Reference
weight: 401

---

## Sirene Model

#### severity (built-in)

```

     "na"       # white
     "critical" # black
     "major"    # red
     "minor"    # yellow
     "info"     # blue
     "other"    # grey
     "ok"       # green

```

#### Categories

```yaml
_sirene_category:incident:
  longname: Incident
  description: Incidents (outage)
  is_enabled: true

_sirene_category:maintenance:
  longname: Maintenance
  description: n/a
  is_enabled: true
```

#### Template

```yaml
_sirene:test_template:
      title: Incident
      severity: ok
      category: info
      description: My description
      publicpage: public_ok
      has_privatepage: true
      body: |
        <p>Hello</p>
        <p>Incident on <b>test apps</b>.</p>
        <p>IT Team</p>
      has_email: false
      has_sms: false
      notify_group: demo
      notify_site: site01, site02
      notify_sitegroup: region01
      notify_app: testapp, testapp2
      notify_customer: Acme_Corp

_sirene:maintenance:
    title: "IT Maintenance"
    severity: info
    category: maintenance
    publicpage: public_maintenance
    has_privatepage: true
    has_email: true
    has_sms: false    
    message: |
      <pre>
      Hi
      A maintenance is starting.
      Please check <a href="http://wwwW.cavaliba.com">Cavaliba</a> for updates.
      IT Team
      </pre>
    has_email: true
    has_sms: false
    description: "Unspecified Maintenance"
    notify_group: 
      - usergroup_01
      - usergroup_03


```

#### Public Pages

```yaml

_sirene_public:
  - name: public_ok
    is_default: yes
    is_enabled: true
    severity: ok
    title: "Nothing"
    message: |
      <p>No public notification.</p>
      <p>Please connect to access private messages.</p>
      <p>IT Team</p>


  - name: public_major
    severity: major
    description: "Major outage ongoing"
    title: Major incident
    message: |
      <p>IT Services are unavailable.</p>
      <p>Please connect to access details.</p>
      <p>IT Team</p>


```

