---
title: Detailled setup
description: Detailled instruction to setup and start Cavaliba
weight: 20
---


## Prerequisites: Setup Docker

You need a docker available environment. You can skip this part if your docker environment is already setup.

You don't have to provide other middleware such as a web server, database server, etc. They are provided as docker containers within the Cavaliba stack.

For example, on a Linux Debian fresh install such as a Virtual Machine or a Desktop  you may have to perform the following actions:

```shell
## Debian

$ sudo apt-get update
$ sudo apt-get install ca-certificates curl
$ sudo install -m 0755 -d /etc/apt/keyrings
$ sudo curl -fsSL https://download.docker.com/linux/debian/gpg -o /etc/apt/keyrings/docker.asc
$ sudo chmod a+r /etc/apt/keyrings/docker.asc

$ echo   "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/debian \
       $(. /etc/os-release && echo "$VERSION_CODENAME") stable" |   sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

$ sudo apt-get update
$ sudo apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

$ sudo groupadd docker
$ sudo usermod -aG docker $USER
$ newgrp docker

$ sudo systemctl enable docker.service
$ sudo systemctl enable containerd.service

```

On Ubuntu :

```shell
## Ubuntu

$ sudo apt-get update
$ sudo apt-get install ca-certificates curl
$ sudo install -m 0755 -d /etc/apt/keyrings

$ sudo curl -fsSL https://download.docker.com/linux/ubuntu/gpg -o /etc/apt/keyrings/docker.asc
$ sudo chmod a+r /etc/apt/keyrings/docker.asc

$ echo \
  "deb [arch=$(dpkg --print-architecture) signed-by=/etc/apt/keyrings/docker.asc] https://download.docker.com/linux/ubuntu \
  $(. /etc/os-release && echo "${UBUNTU_CODENAME:-$VERSION_CODENAME}") stable" | \
  sudo tee /etc/apt/sources.list.d/docker.list > /dev/null

$ sudo apt-get update
$ sudo apt-get install docker-ce docker-ce-cli containerd.io docker-buildx-plugin docker-compose-plugin

$ sudo groupadd docker
$ sudo usermod -aG docker $USER
$ newgrp docker

$ sudo systemctl enable docker.service
$ sudo systemctl enable containerd.service
```

To test your installation:
```shell
$ docker version
$ docker run hello-world
```
If you see Docker versions and a Docker Hello World message, everything is fine. The Hello-World image was downloaded and started successfully on your host.


## Get Cavaliba Release

In your working directory, enter the following command to download Cavaliba from the public repository. Choose the appropriate version. When in doubt, use the highest number for the latest release.

```bash
$ cd myworkdir/
$ wget https://cavaliba.com/download/cavaliba/latest.tar.gz
$ tar zxvf latest.tar.gz
```
You should see a new `3.X.Y/` directory with startup files, source code, and empty data folders. The exact version number may vary.

To check downloaded content:

```shell
$ cd 3.X.Y/  


$ tree -L 1
├── LICENSE
├── README.md
├── files/                       <= files in/out with Cavaliba (import, mail, ...)
├── source/                      <= source code
├── docker-compose.yml           <= docker starter
├── env.template                 <= cavaliba configuration template
└── nginx.conf                   <= logo/ and custom web templates

```



## Adapt Docker Environment Template

```bash
$ cp env.template .env
```

Don't forget the dot at the beginning of the `.env` filename.


This is the only file you need to customize to get started quickly.

The `.env` file contains important parameters such as passwords and security items needed to start the application.

Edit the relevant part in this newly created `.env` file like this:


```bash
$ vi .env

CAVALIBA_DOCKER_IMAGE=cavaliba/cavaliba:3.X.Y          # Upgrade later here

# Network: root FQDN/URL for *your* Cavaliba
CAVALIBA_CSRF_TRUSTED_ORIGINS="http://127.0.0.1:8000"  # HERE: set your FQDN and port
CAVALIBA_PORT=8000                                     # HERE: set your HTTP port on your host (80, 8000, 8080, etc.)

# Admin user (initial)
CAVALIBA_ADMIN_PASSWORD=change_again                   # HERE: set Cavaliba app 'admin' built-in account initial password
CAVALIBA_ADMIN_EMAIL=admin@mydomain.com

# Database
CAVALIBA_DB_USER=cavaliba                              # You can use root; then first launch must be repeated twice
CAVALIBA_DB_PASSWORD=changeme_please                   # HERE: set a password for the internal Cavaliba database
CAVALIBA_DB_ROOT_PASSWORD=changeme_please_also         # HERE: set a different password for the DB root account

CAVALIBA_DB_ENGINE=django.db.backends.mysql
CAVALIBA_DB_HOST=cavaliba_db                           # Container name; change if external DB used
CAVALIBA_DB_PORT=3306
CAVALIBA_DB_DATABASE=cavaliba


# Encryption key for sensitive fields in DB
CAVALIBA_CIPHER_KEY="Change me. Please..."             # Set an encryption key for sensitive DB content. Keep it safe.

# Framework & Cookie protection
CAVALIBA_SECRET_KEY=changeme_with_a_long_string
CAVALIBA_ALLOWED_HOSTS="localhost 127.0.0.1 *"
```

## Start the Application

Once the `.env` file is ready, you may start Cavaliba as follows:

```bash
$ docker compose up
```

You may later add a `-d` option to run Docker in the background.

You may observe the different startup steps:

* Download of various Docker images: nginx, mariadb, redis, and cavaliba (from Docker Hub)
* MariaDB database initial creation and startup
* Redis cache server startup
* Cavaliba async tasks container startup (Celery)
* Cavaliba app container startup (init app, translations, admin account update, DB migrations, etc.)
* Web server startup (nginx)


Inspect the result like this (truncated):

```shell
$ docker ps
IMAGE                  (...) STATUS                    PORTS                      NAMES
nginx:1.25.2                Up 10 seconds             0.0.0.0:8000->80/tcp       cavaliba_nginx
cavaliba/cavaliba:3.10      Up 10 seconds             8001/tcp                   cavaliba_app
cavaliba/cavaliba:3.10      Up 10 seconds                                        cavaliba_celery
redis:7.0.2-alpine3.16      Up 13 seconds (healthy)   6379/tcp                   cavaliba_redis
mariadb:10.10               Up 13 seconds (healthy)   3306/tcp                   cavaliba_db

```

You'll notice a new `db/` folder in your `cavaliba/` main folder. It contains the (persistent) database content.

## Connect and Sign In with Admin Account

Open your browser to your host/port combination:

```bash
firefox http://myhost:8000/home/private/
```

You'll be presented with the sign-in screen. Use the `admin` built-in account with the password you provided in the `.env` file.



```


## If Anything Went Wrong

Check running containers:

```bash
docker ps -a
```

Check logs for error messages:

```bash
docker logs -f cavaliba_nginx
docker logs -f cavaliba_app
docker logs -f cavaliba_celery
docker logs -f cavaliba_db
docker logs -f cavaliba_redis
```

CSRF error message in the app?

* Verify the `.env` file and the `CAVALIBA_CSRF_TRUSTED_ORIGINS` value

Error in sign-in web form?

* Double-check your admin password in the `.env` file


## What to Do Next?

You may:

* Have a quick tour of the application including importing demo data

* Go to additional setup: configuration, authentication, TLS/SSL, permissions, backups, emails, SMS, etc.
