---
title: Discover the UI
description: Getting started with Cavaliba - explore the interface, create your first user, and manage data
weight: 10
draft: false
---

This tutorial assumes a fresh installation of Cavaliba version 3.24+, either on a laptop, virtual machine, server, or any similar environment. You should have the admin account password, and the database should be empty. If needed, refer to the quickstart guide to flush and restart with a clean installation.

Most operations are performed directly from the Web user Interface (UI, or Web UI in this tutorial).

Some operations may be easier from the command-line interface (CLI), such as loading tutorial files provided with Cavaliba.  In that case, make sure you have the `cavaliba` CLI alias configured as described in the Getting Started guide.

    $ alias cavaliba='docker exec -it cavaliba_app python manage.py cavaliba'
    $ cavaliba version
    3.24.1



## Sign In

After starting Cavaliba, navigate to the login page and authenticate as the admin user with your configured password from `.env` installation file.

![Cavaliba Sign In](signin.png)

**Note on Production Deployments:** you'll typically replace the admin account with proper user management strategies such as:
- Internal cavaliba individual accounts
- Directory accounts (LDAP/Active Directory)
- Federated authentication (SAML/OIDC)
- Various levels of admin roles and permissions for users in charge of system and data administration in Cavaliba



## Interface Overview

Once sign-in is completed you'll see the (almost) empty welcome page.

![Cavaliba Initial View](initial.png)

Take a little time to navigate around the interface, enter various menu. You can always come back to the Welcome page by clicking on the top left `home`icon or Cavaliba label.

### Sidebar 

The sidebar on the left presents links to services, identity management, Asset management and Admin tools. 

The sidebar can be retracted with the small *burger* button at the top of the screen to provide more space for large data tables in the main screen.

The sidebar is highly customizable and is a good place to put links to most useful assets and tools.


### User menu

On the top right corner, a standard dropdown *User menu* provides various features such as `logout`, `user preferences`, etc. As an admin (in this tutorial), you'll have a link to the DB administation tool.

![Cavaliba User Menu](user_menu.png)


## Cavaliba Configuration

Let's make some configuration change. Many configuration options are available from the UI with the sidebar menu `Configuration`.

- Click on the Configuration link in the sidebar.
- Select the `home` button under the configuration page. 

You'll be presented with a subset of the configurations options, dedicated to the central (home) part of Cavaliba.

Your exact number of toplevel Configuration option (HOME, USER, DATA, ...) will expand as you activate more features of Cavaliba.

Some low-level / system configurations options are located in the docker `.env` file you may have encountered during the setup process. This is so because they either need a full system restart, or are related to hosting and can break the restart of the system and thus must be a changed from CLI by a sysadmin.


![Configuration access](configuration_access.png)


Then:
- Scroll down to the two SIDEBAR options
- Set a short label `Tuto` for SIDEBAR_ENV
- Set a color in SIDEBAR_COLOR like RGB #000030 (dark blue)


![Configuration edit](configuration_edit.png)


Click on SAVE button at the top of the screen.

Notice the new sidebar and badge.

![Configuration success](configuration_success.png)


See the Reference documentation for extended explanation of each configuration option. 

You have learned how to edit and save Cavaliba configuration.



## Logs

The log tool in the sidebar lets you inspect recent activity in Cavaliba. You can search with a basic filter, or by loglevel.

![Log](log_access.png)

These logs are produced during various action in Cavaliba like access to tools and function, data modification, background tasks and activities. You should find your last operations.

A periodic task in Cavaliba handles automatic log cleanup. Several Configuration options let you define duration and size before cleanup.

Logs should be kept in the database for a small duration like a few days or weeks for immediate access from the UI. For longer storage, and proper log processing, sending log to an external log collector is a good idea.

## Data Revisions

Data Revision is the mechanism to capture and store all modification made to data Assets.

You can access Revisons in two way:
- on each object (User, Group, Instance of any Asset, etc.), with a small button "Revision".
- from the admintools Sidebar menu, to see all Data Revisions in chronological order.

Clikc ont the Sidebar `Admintools` link 
Clikc on the Data Revision.

You are presented with the last Revisions:

![data Revision](revision_admintool.png)

The exact content may vary in your own contet. 

## Export

Cavaliba can be configured to periodically export its content. For example you may define a task to create a JSON file every night with all Users or any other list of assets. We'll see later how to configure such exports once we have created relevant content.

The sidebar `Export` menu gives you access to the exported files, and the result of the last task execution. You can download files from here. Remote systems can automatically fetch the exported file either from system access (SFTP) or with the API.

![expot](export.png)




## Import

The `Import` tool from the Sidebar is provided to import bulk files or objects defined by YAML code, from the UI, since you may not want or be able to work from the command line (CLI).

Cavaliba is in the business of data management. Importing data is a large and important topic. All assets and objects won't be created manually one by one in the Web UI. 

Obviously you'll need to connect or receive bulk data from external sources.

For different reasons, some assets or objects are better handled with *code*, such as JSON or YAML definitions which you can commit in GIT like revision systems, create on the fly with your own tools, etc.

Let's practice import.

First, click on the `import` link in the sidebar.

Copy the following YAML in the YAML text field.

```yaml
- classname: _user
  login: papageno
```

This says *in the _user builtin Schema, add a user with login value equal to `papageno`*. Be careful with blank space.

Click on the `Check` button, and if the answer is OK, on the Import button. You've added a (basic) user entry to Cavaliba.

![import](import.png)


If you go to the Users menu from the Sidebar, you'll see your `papageno` user as well as your current builtin `account`. 

This is a good way to suggest to you to proceed to PART-2 of this tutorial, dedicated to User management.





