---
title: enumerate
description: FieldType Enumerate
weight: 240
---

Provides predefined choice lists with support for rich metadata and visual widgets (icons, colors, etc.).

## dataformat: enumerate

```yaml
  MYFIELD:
      dataformat: enumerate
      dataformat_ext: enum_name
      cardinal_max: 0
```

## dataformat_ext

**Required**: References an `_enumerate` schema instance that defines the choice list.

- Value: keyname of an `_enumerate` instance
- Example: `dataformat_ext: enum_severity` references the "enum_severity" enumerate

## Multivalue

Multi-value is supported for selecting multiple values from the enumeration.

## Examples

### Schema Definition

```yaml
- classname: _schema
  keyname: alert
  severity:
    dataformat: enumerate
    dataformat_ext: enum_severity
    displayname: Severity
    description: Alert severity level
```

### Instance Example

```yaml
- classname: alert
  keyname: alert001
  severity: Critical
```

## Widget Types

Available widget symbols:

- `red_circle` - 🔴 (red circle)
- `orange_circle` - 🟠 (orange circle)
- `yellow_circle` - 🟡 (yellow circle)
- `green_circle` - 🟢 (green circle)
- `purple_circle` - 🟣 (purple circle)
- `brown_circle` - 🟤 (brown circle)
- `blue_circle` - 🔵 (blue circle)
- `white_circle` - ◯ (white circle)
- `black_circle` - ⬤ (black circle)
- `html:...` - Custom HTML
- Empty/default - No widget

## Notes

- Enumerations must be pre-defined as `_enumerate` instances
- Widget icons display in list and detail views
- Subfields provide rich metadata for each choice
- Caching improves performance for large enumerations
- Useful for statuses, categories, classifications, and choices
- Changes to enumerations immediately available in UI
