---
title: password
description: FieldType Password
weight: 210
---

Represents a Password value. 


## dataformat: password

```yaml
  MYFIELD:
      (...)
      dataformat: password
      dataformat_ext: "store|hash minlen:8 maxlen:64 complexity:3"
      (...)
```

## dataformat_ext

Optional **dataformat_ext** can be a string of multiple options:

- **hash**: Password is stored as a one-way sha256 salted hash in DB ; default
- **store**: Password is stored as a reversible symmetric hmac/salted sha256 multi iteration string
- **minlen:INT**: minimun password length check at creation time (default 8)
- **maxlen:INT**: maximum password length  check at creation time (default 64)
- **compleixty:INT**: number of complexify factors (lower, upper, digit, other) at creation time (default 3)


## Multivalue

Multi-value not is supported.


## Encyption and use case

A master cipher key is defined in the `.env` system file at setup time. If you lose this key, you won't be able to decrypt sotred (store) passwords.

- **hash** : hash mode is useful to check a provided password against the stored value
- **store**: store mode is useful to retrieve clear value (e.g to call an external API)


## Examples

### cavctl


    $ ./cavctl/bin/cavctl schema --schema test
        "my_pass1": {
            "displayname": "Password field (Hash)",
            "description": "Type a password",
            "is_enabled": true,
            "dataformat": "password",
            "dataformat_ext": "hash",
            "order": 330,
            "page": "password",
            "cardinal_min": 0,
            "cardinal_max": 1,
            "default_value": ""
        },
        "my_pass2": {
            "displayname": "Password field (Store)",
            "description": "Type a password",
            "is_enabled": true,
            "dataformat": "password",
            "dataformat_ext": "store",
            "order": 331,
            "page": "password",
            "cardinal_min": 0,
            "cardinal_max": 1,
            "default_value": ""
        }


    $ ./cavctl/bin/cavctl instance --schema test --id 48

        "my_pass1": "$sha256$fa187d0409ac95af77a0b1e(...)2dee4f8a4a674ed$",
        "my_pass2": "IQQWAw1LQdtJ65XoSHFaOu8SDw=="


### Schema Definition

```yaml
- classname: _schema
  keyname: person
  my_pass:
      displayname: Password field
      description: 'Type a password (minlen:4 maxlen:8 complexity:4)'
      dataformat: password
      dataformat_ext: 'hash minlen:4 maxlen:8 complexity:4'
```



### Instance Example

```yaml
- classname: person
  keyname: john_smith
  name: "John Smith"
  my_pass: "$sha256$fa187d0409ac95af77a0b1ee8d9(...)53ea4e551658a72db38abb2dee4f8a4a674ed$"


- classname: _apikey
  keyname: key1
  displayname: API key1
  secret: "$sha256$3146ac549c20d3dd58c(...))9222f2ce1655abaad9$"
  description: API Key
  ip_filter: '*'
  acl: "role:role_api567"
```
