---
title: Admin Tools
description: Admin Tools for system maintenance and operations
weight: 710
---

## Overview

Cavaliba provides a built-in Admin Tools interface for system administrators to perform critical maintenance and operational tasks. These tools are accessible from the administration dashboard and require the `p_admintools` permission.

Access the Admin Tools with the `admintool` sidebar button or at  `/private/admintools/`


## Permissions

All Admin Tools require the `p_admintools` permission. This permission should only be granted to trusted system administrators. It is available to all `admin` users.   

To check and manage admin permissions:
1. Navigate to `Administration > Roles`
2. Grant the `p_admintools` permission to selected roles
3. Map individual users and/or group to selected roles



## Available Tools


### Counters (Schema Counters & BigSet Update)

**Purpose**: Update schema counters and bigset status for all schemas

**When to use**:
- After bulk data operations (imports, migrations)
- When schema statistics appear out of sync
- During routine maintenance

**Command**: Click the "Counters" button

**What it does**:
- Recalculates instance count for each schema
- Updates bigset cache status
- Refreshes schema statistics used by the UI for pagination

**Impact**: Negligible. Safe to use.

**Alternative**: this task is included in the automatic daily housekeeping.




### EAV Refresh

**Purpose**: Rebuild the Entity-Attribute-Value (EAV) cache for improved query and filtering responses

**When to use**:
- When out of sync response / missing new entries in filtering


**Command**: Click the "EAV Refresh" button

**What it does**:
- Rebuilds the complete EAV cache from the database


**Impact**: Long-running task. System performance may be temporarily reduced. Cache will be fully rebuilt after completion.

**Note**: This is an async task that runs in the background. Progress can be monitored in the application logs.

**Alternative**: this task is included in the automatic daily housekeeping.



### EAV Purge

**Purpose**: Clear the EAV cache to remove orphan entries and improve queries and filtering

**When to use**:
- When cache may be corrupted

**Command**: Click the "EAV Purge" button

**What it does**:
- Recreates all cache entries from main Database


**Impact**: Long-running task. System performance may be temporarily reduced. Cache will be fully rebuilt after completion.

**Note**: This is an async task that runs in the background. Progress can be monitored in the application logs.

**Alternative**: this task is included in the automatic daily housekeeping.



### Data Revisions

**Purpose**: View data revision tracking history

**When to use**:
- Audit data changes and modifications
- Track who changed what and when
- Investigate data mutation issues
- Review revision history

**Command**: Click the "Revision" button

**Features**:
- View all recorded data revisions (ordered by most recent first)
- Pagination support (1000 items per page by default)
- Columns: ID, Date, Schema, Instance, Action, User
- Filter by custom page size using `?size=500` parameter

**URL Parameters**:
- `page`: Page number (default: 1)
- `size`: Items per page (default: 1000, max: 10000)

**Example**:
```
/private/admintools/revision/?page=1&size=500
/private/admintools/revision/?page=2
```



### DB Reset (Factory Reset)

**Purpose**: Reset the database to its initial (empty) state

**⚠️ DANGER**: This action is irreversible and deletes ALL data

**When to use**:
- Only when explicitly needed
- Development/testing environments
- Fresh system initialization

**What it does**:
- Deletes all schemas (DataClass)
- Deletes all schema fields (DataSchema)
- Deletes all data instances
- Deletes all users and groups
- Deletes all configuration
- Resets the database to an empty state

**Command**: Click the "DB Reset" button and confirm in the modal dialog

**Impact**: Complete data loss. All application data is permanently removed.

**Recovery**: Only possible from database backups.



## Command-line Alternatives

Most admin tool operations have command-line equivalents accessible via the Django management command:

```bash
# EAV operations
cavaliba cache --eav_refresh
cavaliba cache --eav_purge
```

