---
title: cavctl
description: cavctl remote CLI command
weight: 92
---

The `cavctl` binary is a standalone command-line tool (CLI) to manage Cavaliba systems remotely. It is is a golang thin wrapper around the Cavaliba API, built with cobra/viper librairies.


## Setup overview

1. Select the appropriate binary from the cavaliba download page
2. Create an API Key in your Cavaliba instance with appropriate permissions (eg. p_info)
3. Optionnaly, create a ~/cavaliba/cavctl.yaml configuration file
4. run `cavctl` from your shell

## Build

You can build your own cavctl binary if your specific binary is not available. Setup GOLANG on your system and download the latest cavaliba dsitribution.

Use the `make build` from the cavaliba/cavctl/ source directory. The resulting binary is in the build/ subfolder. 

You can copy/install this binary on other machines with the same OS/ARCH. See GOLANG cross compilation for details.



## Help flag

```
$ cavctl --help

cavctl is a CLI standalone command to manage remote Cavaliba systems

Usage:
  cavctl [flags]
  cavctl [command]

Available Commands:
  asset       displays asset information
  completion  Generate the autocompletion script for the specified shell
  help        Help about any command
  info        display information about a Cavaliba instance
  ping        ping remote cavaliba instance
  schema      display schema information from Cavaliba instance
  user        displays user information
  version     displays remote cavaliba version

Flags:
      --client_id string       API Client ID
      --client_secret string   API Client Secret
      --config string          config file (default is $HOME/.cavaliba/cavctl.yaml)
      --expand                 Expand result
  -f, --format string          Output format : json, yaml, txt (default "json")
  -h, --help                   help for cavctl
      --id int                 ID filter
      --key string             Key filter
      --page int               Page number (default 1)
      --schema string          Schema filter
      --search string          Search filter
      --size int               Page size (default 10)
      --ssl_skipverify         skip TLS/SSL cert verification
      --timeout int            API timeout (msec) (default 2000)
      --url string             Cavaliba Root URL (default "http://localhost:8000/api/")
  -v, --verbose                verbose output

Use "cavctl [command] --help" for more information about a command.

```

## Empty command

Retrieves the cavctl version.

```bash
$ cavctl
cavctl version: 1.3.0
```


## Explicit command-line parameters

In order to query a cavaliba system, you need to define the API endpoint :

```
$ cavctl version --url http://127.0.0.1:8000/ --client_id key1 --client_secret goodsecret
{
    "version": "3.27.3"
}
```

You can check the status code with the `-v` option (verbose):

```
$ cavctl version --url http://127.0.0.1:8000/ --client_id key1 --client_secret wrongsecret -v
(...)
status:     401
(...)
```

A 401 status code is an unauthorized response.


## Use a config file

To save typing, use a config file.

```
$ cavctl --config myconfig.yaml

```

By default, `cavctl` will try `$HOME/.cavaliba/cavctl.yaml` which you should populate with your regular parameters.


Example:

```yaml cavaliba.yaml
url: http://localhost/
client_id: key1
client_secret: xxxxxxxxxxxxx
timeout: 5000
ssl_skipverify: false
```


## Verbose flag

Use `-v` option to display more informations, such as config file, API URL, duration, response code, etc.

```bash
$ cavctl version -v
----- Configuration -----
Configuration:   /home/cavaliba/.cavaliba/cavctl.yaml
url:             http://localhost:8000/api/
timeout:         2000
client_id:       test
ssl_skipverify:  true

----- API Request -----
API:        http://localhost:8000/api/version/

----- API Response -----
status:     200
duration:   44.22706ms

----- DATA -------------
{
  "version": "3.27.2"
}
```

## ssl_skipverify

Version: 1.1.0


Ignore Cavaliba URL TLS/SSL Cerificate check (duration, issuer, fqdn).


Default: false

Usage:

```
# CLI
cavctl --ssl_skipverify

# envvar
export CAVALIBA_SSL_SKIPVERIFY=true && cavctl -v
ssl_skipverify: true


# persist in cavaliba.yaml:
ssl_skipverify: true
```


# Commands

## ping

It can be used to manage a Load-Balancer and check connectivity to a remote Cavaliba system.

Permission required: None

```bash
cavctl ping
{
  "status": "OK"
}
```


## version

This command calls the configured cavaliba instance and retrieves it's version.

Permission required: p_info


```bash
$ cavctl version
{
    "version": "3.21.0"
}
```


## info

This command calls the configured cavaliba instance and retrive key system informations.

permission required: p_info

```bash
$ cavctl info
{
  "schema_count": 20,
  "field_count": 168,
  "instance_count": 956,
  "instance_eav": 9679,
  "instance_file": 0,
  "user_count": 504,
  "group_count": 61,
  "role_count": 14,
  "permission_count": 113,
  "visitor_count": 0,
  "configuration_count": 60,
  "log_count": 46606,
  "apistat_count": 1,
  "dashboard_count": 24,
  "smsjournal_count": 0,
  "status_raw_count": 24186,
  "status_sample_hour_count": 137,
  "status_sample_day_count": 12
}
```

# Reference

```bash

    cavctl ping
    cavctl version
    cavctl info

    cavctl user
    cavctl user --page 3 --size 5 --format json
    cavctl user --search admi
    cavctl user --id 1
    cavctl user --key patricia

    cavctl schema
    cavctl schema --schema site --format yaml


    cavctl asset --search anco
    cavctl asset --id 35
    cavctl asset --schema site
    cavctl asset --schema site --search anc
    cavctl asset --schema site --key ancon
    cavctl asset --schema site --search anc --format json --page 2 --size 1 --expand

```


# Revisions

    2025/11/30 - v1.3.0 - schema, asset, uset ; multi-permissions ; paginate ; json/yaml
    2025/08/22 - v1.2.0 - error display, ssl_skip_verify
    2025/08/20 - v1.0.0 - version command

