# (c) cavaliba.com - data - field - time

import datetime

from .field import Field

# -------------
# TIME
# -------------
class FieldTime(Field):


    # 'hh:mm:ss'

    def merge_import(self, data):
        # no split composite !
        self.value = []
        if type(data) is str:
            if len(data) == 8:
                self.value = [data]
        elif type(data) is list:
            for i in data:
                if len(i) == 8:
                    self.value.append(i)

                
    def is_valid(self):
        r = super().is_valid()
        for v in self.value:
            if type(v) is str:
                if len(v) == 8:
                    return False
            try:
                timeformat = "%H:%M:%S"
                validtime = datetime.datetime.strptime(v, timeformat)
            except:
                return False
        return r



