# (c) cavaliba.com - home - configuration_default.py


CONFIGURATION_DEFAULT = {

    "env": {
        "CAVALIBA_AUTH_MODE": "local",
        "CAVALIBA_FORCE_LOGIN": "admin",
        "CAVALIBA_DEBUG_AAA": "no",
        "CAVALIBA_FILESTORE": "/app/files/filestore/",
    },

    "home": {
        "GLOBAL_APPNAME": "Cavaliba",
        "CSV_DELIMITER": ',',
        "LOGO_SIZE": 0,
        "LOG_DEBUG": "yes",
        #"LOG_KEEP_DAYS": 31,
        "LOG_KEEP_DAYS_DEBUG": 7,
        "LOG_KEEP_DAYS_INFO": 120,
        "LOG_KEEP_DAYS_WARNING": 365,
        "LOG_KEEP_DAYS_ERROR": 365,
        "LOG_KEEP_DAYS_CRITICAL": 99999,
        "LOG_MAX_ENTRIES": 2200000,
        "LOG_EXCLUDED_IP": "",
        "BETA_PREVIEW": 'no',
        "SIDEBAR_COLOR": "#000000",
        "SIDEBAR_ENV": "",
        "REVISION_DISPLAY": 10,
        "REVISION_KEEP_DAYS": 999,
    },
    "user": {
        "TRUSTED_ANONYMOUS_IPS": "",
        # oauth2, basic, local, forced
        "AUTH_FEDERATED_LOGIN_FIELD": "X-User",
        "AUTH_FEDERATED_EMAIL_FIELD": "X-Email",
        "AUTH_LOGIN_REMOVE_DOMAIN": "yes",
        # manual, create, update, sync, visitor
        "AUTH_PROVISIONING": "manual",
        "CACHE_SESSION": "yes",
    },
    "data": {
        "DATA_DEFAULT_SIZE": 200,
        "DATA_MAX_SIZE": 500,
        "DATA_BIGSET_SIZE": 500,
        "EXPORT_INTERACTIVE_MAX_SIZE": 5000,
    },
    "sirene": {
        "SIRENE_APPNAME": "Sirene",
        "PUBLIC_MAX_ITEMS": 6,
        "DEFAULT_DURATION_MINUTE": 1440,
        "PUBLIC_SORT_ORDER": "creation",
        "PUBLIC_SKIP_TO_TRUSTED": 'no',
        "USER_MAX_NOTIFICATION": 100,
        "EMAIL_MAX_NOTIFICATION": 100,
        "EMAIL_FOLDER": "/app/files/mail/",
        "EMAIL_MODE": "stdout",
        "EMAIL_FROM": "noreply@findadomain.com",
        "EMAIL_SMTP_BATCH": 100,
        "EMAIL_PREFIX": "[Cavaliba] ",
        "EMAIL_UPDATE_PREFIX": "[Cavaliba Update] ",
        "EMAIL_MESSAGE_TEMPLATE": "default",
        "EMAIL_TEST_SUBJECT": "Cavaliba - TEST TEST TEST - Please ignore.",
        "EMAIL_TEST_CONTENT": "Test.Ignore.",
        "SMS_MAX_NOTIFICATION": 30,
        "SMS_FOLDER": "/app/files/sms/",
        "SMS_PREFIX": "[Cavaliba] ",
        "SMS_UPDATE_PREFIX": "[Cavaliba Update] ",
        "SMS_TEST": "Cavaliba - TEST TEST TEST - Please ignore.",
        "SMS_QUOTA_PER_DAY": 100,
        "SMS_MODE": "stdout",
        "SMS_WARNING": "IMPORTANT: All SMS activity is recorded for security purposes.",
        # "APP_CLASS": "app",
        # "SITE_CLASS": "site",
        # "SITEGROUP_CLASS": "sitegroup",
        # "CUSTOMER_CLASS": "customer",
        "NOTIFY_FIELDS": "user group app site",
        "NOTIFY_SUBSCRIPTIONS": "site:app",
    },
    "status": {
        "STATUS_APPNAME": "StatusPage",
        "STATUS_RAW_KEEP_DAYS": 7,
        "STATUS_SAMPLE_HOUR_KEEP_DAYS": 31,
    },
    "ipam": {
        "IPAM_APPNAME": "IPAM - IP Management",
    },
}
