# (c) cavaliba.com - app_status - tasks.py

from celery import shared_task

import app_home.cache as cache
from app_home.log import log, DEBUG

from app_status.common import run_monitors

from app_status.common import sample_hour
from app_status.common import sample_day

from app_status.common import cleanup_raw
from app_status.common import cleanup_hour


# @app.task
@shared_task
def task_run_monitor():

    # flush_cache_per_request()
    cache.init()

    aaa = None
    count = run_monitors()
    log(DEBUG, aaa=aaa, app="status", view="cron", action="run_monitor", status="OK", data=f"{count} run")


#   -- sample

@shared_task
def task_sample_hour():

    # flush_cache_per_request()
    cache.init()

    aaa = None
    total = sample_hour()
    log(DEBUG, aaa=aaa, app="status", view="cron", action="sample_hour", status="OK", data=f"{total} updated")


@shared_task
def task_sample_day():

    # flush_cache_per_request()
    cache.init()

    aaa = None
    total = sample_day()
    log(DEBUG, aaa=aaa, app="status", view="cron", action="sample_day", status="OK", data=f"{total} updated")


#   -- cleanup

@shared_task
def task_cleanup_raw():

    # flush_cache_per_request()
    cache.init()

    aaa = None
    cleanup_raw()
    log(DEBUG, aaa=aaa, app="status", view="cron", action="cleanup_raw", status="OK", data="")


@shared_task
def task_cleanup_hour():

    # flush_cache_per_request()
    cache.init()

    aaa = None
    cleanup_hour()
    log(DEBUG, aaa=aaa, app="status", view="cron", action="cleanup_hour", status="OK", data="")
